-- ============================================
-- TUNISIAN TVA SYSTEM MIGRATION
-- ============================================
-- This migration adds comprehensive TVA (VAT) support to the platform
-- with backward compatibility for existing data

-- Step 1: Add TVA fields to catalogs (with defaults)
ALTER TABLE "catalogs" ADD COLUMN "default_tva_rate" DECIMAL(5,2) NOT NULL DEFAULT 19;

-- Step 2: Add TVA fields to products (with defaults)
ALTER TABLE "products" ADD COLUMN "tva_rate" DECIMAL(5,2) NOT NULL DEFAULT 19;
ALTER TABLE "products" ADD COLUMN "tva_exempt" BOOLEAN NOT NULL DEFAULT false;
ALTER TABLE "products" ADD COLUMN "tva_exempt_reason" TEXT;

-- Step 3: Add TVA exemption fields to users (with defaults)
ALTER TABLE "users" ADD COLUMN "tva_exempt" BOOLEAN NOT NULL DEFAULT false;
ALTER TABLE "users" ADD COLUMN "tva_exempt_reason" TEXT;
ALTER TABLE "users" ADD COLUMN "annual_turnover" DECIMAL(15,2);
ALTER TABLE "users" ADD COLUMN "tva_exempt_valid_until" TIMESTAMP(3);

-- Step 4: Add TVA fields to quotation_items
-- First add with defaults, then update based on existing data
ALTER TABLE "quotation_items" ADD COLUMN "discount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotation_items" ADD COLUMN "tva_rate" DECIMAL(5,2) NOT NULL DEFAULT 19;
ALTER TABLE "quotation_items" ADD COLUMN "tva_exempt" BOOLEAN NOT NULL DEFAULT false;
ALTER TABLE "quotation_items" ADD COLUMN "total_ht" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotation_items" ADD COLUMN "tva_amount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotation_items" ADD COLUMN "total_ttc" DECIMAL(10,2) NOT NULL DEFAULT 0;

-- Update existing quotation_items with calculated values
UPDATE "quotation_items" SET
  "total_ht" = "total_price" / 1.19,  -- Assuming 19% TVA was included
  "tva_amount" = "total_price" - ("total_price" / 1.19),
  "total_ttc" = "total_price"
WHERE "total_ht" = 0;

-- Step 5: Add TVA fields to quotations
ALTER TABLE "quotations" ADD COLUMN "total_brut_ht" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotations" ADD COLUMN "total_discount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotations" ADD COLUMN "total_net_ht" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotations" ADD COLUMN "tva_19_amount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotations" ADD COLUMN "tva_7_amount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotations" ADD COLUMN "tva_0_amount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotations" ADD COLUMN "total_tva" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotations" ADD COLUMN "net_a_payer" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "quotations" ADD COLUMN "net_a_payer_words" TEXT;
ALTER TABLE "quotations" ADD COLUMN "customer_tva_exempt" BOOLEAN NOT NULL DEFAULT false;

-- Update existing quotations with calculated values
UPDATE "quotations" SET
  "total_brut_ht" = "subtotal",
  "total_net_ht" = "subtotal",
  "total_tva" = "tax_amount",
  "tva_19_amount" = "tax_amount",
  "net_a_payer" = "total_amount"
WHERE "net_a_payer" = 0;

-- Step 6: Add TVA fields to order_items
ALTER TABLE "order_items" ADD COLUMN "discount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "order_items" ADD COLUMN "tva_rate" DECIMAL(5,2) NOT NULL DEFAULT 19;
ALTER TABLE "order_items" ADD COLUMN "tva_exempt" BOOLEAN NOT NULL DEFAULT false;
ALTER TABLE "order_items" ADD COLUMN "total_ht" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "order_items" ADD COLUMN "tva_amount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "order_items" ADD COLUMN "total_ttc" DECIMAL(10,2) NOT NULL DEFAULT 0;

-- Update existing order_items with calculated values
UPDATE "order_items" SET
  "total_ht" = "total_price" / 1.19,
  "tva_amount" = "total_price" - ("total_price" / 1.19),
  "total_ttc" = "total_price"
WHERE "total_ht" = 0;

-- Step 7: Add TVA fields to orders
ALTER TABLE "orders" ADD COLUMN "total_brut_ht" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "orders" ADD COLUMN "total_discount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "orders" ADD COLUMN "total_net_ht" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "orders" ADD COLUMN "tva_19_amount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "orders" ADD COLUMN "tva_7_amount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "orders" ADD COLUMN "tva_0_amount" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "orders" ADD COLUMN "total_tva" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "orders" ADD COLUMN "net_a_payer" DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE "orders" ADD COLUMN "net_a_payer_words" TEXT;
ALTER TABLE "orders" ADD COLUMN "customer_tva_exempt" BOOLEAN NOT NULL DEFAULT false;

-- Update existing orders with calculated values
UPDATE "orders" SET
  "total_brut_ht" = "subtotal",
  "total_net_ht" = "subtotal",
  "total_tva" = "tax_amount",
  "tva_19_amount" = "tax_amount",
  "net_a_payer" = "total_amount"
WHERE "net_a_payer" = 0;

-- Step 8: Create catalog_product_tva table for catalog-specific TVA overrides
CREATE TABLE "catalog_product_tva" (
    "id" TEXT NOT NULL,
    "catalog_id" TEXT NOT NULL,
    "product_id" TEXT NOT NULL,
    "tva_rate" DECIMAL(5,2) NOT NULL,
    "tva_exempt" BOOLEAN NOT NULL DEFAULT false,
    "reason" TEXT,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "catalog_product_tva_pkey" PRIMARY KEY ("id")
);

-- Step 9: Create indexes and constraints
CREATE UNIQUE INDEX "catalog_product_tva_catalog_id_product_id_key" ON "catalog_product_tva"("catalog_id", "product_id");

-- Step 10: Add foreign keys
ALTER TABLE "catalog_product_tva" ADD CONSTRAINT "catalog_product_tva_catalog_id_fkey" FOREIGN KEY ("catalog_id") REFERENCES "catalogs"("id") ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE "catalog_product_tva" ADD CONSTRAINT "catalog_product_tva_product_id_fkey" FOREIGN KEY ("product_id") REFERENCES "products"("id") ON DELETE CASCADE ON UPDATE CASCADE;
