/*
  Warnings:

  - A unique constraint covering the columns `[catalog_id,slug]` on the table `categories` will be added. If there are existing duplicate values, this will fail.
  - A unique constraint covering the columns `[catalog_id,slug]` on the table `products` will be added. If there are existing duplicate values, this will fail.
  - A unique constraint covering the columns `[catalog_id,sku]` on the table `products` will be added. If there are existing duplicate values, this will fail.

*/
-- DropIndex
DROP INDEX "categories_slug_key";

-- DropIndex
DROP INDEX "products_sku_key";

-- DropIndex
DROP INDEX "products_slug_key";

-- AlterTable
ALTER TABLE "banner_slides" ADD COLUMN     "catalog_id" TEXT;

-- AlterTable
ALTER TABLE "categories" ADD COLUMN     "catalog_id" TEXT;

-- AlterTable
ALTER TABLE "products" ADD COLUMN     "catalog_id" TEXT;

-- CreateTable
CREATE TABLE "catalogs" (
    "id" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "slug" TEXT NOT NULL,
    "description" TEXT,
    "logo_url" TEXT,
    "primary_color" TEXT,
    "is_active" BOOLEAN NOT NULL DEFAULT true,
    "is_default" BOOLEAN NOT NULL DEFAULT false,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "catalogs_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "catalog_customers" (
    "id" TEXT NOT NULL,
    "catalog_id" TEXT NOT NULL,
    "customer_id" TEXT NOT NULL,
    "can_order" BOOLEAN NOT NULL DEFAULT true,
    "can_quote" BOOLEAN NOT NULL DEFAULT true,
    "assigned_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "assigned_by" TEXT,

    CONSTRAINT "catalog_customers_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "catalogs_slug_key" ON "catalogs"("slug");

-- CreateIndex
CREATE UNIQUE INDEX "catalog_customers_catalog_id_customer_id_key" ON "catalog_customers"("catalog_id", "customer_id");

-- CreateIndex
CREATE UNIQUE INDEX "categories_catalog_id_slug_key" ON "categories"("catalog_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "products_catalog_id_slug_key" ON "products"("catalog_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "products_catalog_id_sku_key" ON "products"("catalog_id", "sku");

-- AddForeignKey
ALTER TABLE "catalog_customers" ADD CONSTRAINT "catalog_customers_catalog_id_fkey" FOREIGN KEY ("catalog_id") REFERENCES "catalogs"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "catalog_customers" ADD CONSTRAINT "catalog_customers_customer_id_fkey" FOREIGN KEY ("customer_id") REFERENCES "users"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "catalog_customers" ADD CONSTRAINT "catalog_customers_assigned_by_fkey" FOREIGN KEY ("assigned_by") REFERENCES "users"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "categories" ADD CONSTRAINT "categories_catalog_id_fkey" FOREIGN KEY ("catalog_id") REFERENCES "catalogs"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "products" ADD CONSTRAINT "products_catalog_id_fkey" FOREIGN KEY ("catalog_id") REFERENCES "catalogs"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "banner_slides" ADD CONSTRAINT "banner_slides_catalog_id_fkey" FOREIGN KEY ("catalog_id") REFERENCES "catalogs"("id") ON DELETE CASCADE ON UPDATE CASCADE;
