import { Router } from 'express';
import { register, login, refreshToken, logout, getCurrentUser, forgotPassword, resetPassword, } from '../controllers/auth.controller.js';
import { authenticate } from '../middleware/auth.js';
const router = Router();
// Public routes
router.post('/register', register);
router.post('/login', login);
router.post('/refresh-token', refreshToken);
router.post('/forgot-password', forgotPassword);
router.post('/reset-password', resetPassword);
// Protected routes
router.post('/logout', authenticate, logout);
router.get('/me', authenticate, getCurrentUser);
export default router;
//# sourceMappingURL=auth.routes.js.map