import { Routes, Route, Navigate } from 'react-router-dom';
import LoginPage from './pages/LoginPage';
import DashboardLayout from './components/DashboardLayout';
import DashboardHome from './pages/DashboardHome';
import ProductsPage from './pages/ProductsPage';
import CreateProductPage from './pages/CreateProductPage';
import CategoriesPage from './pages/CategoriesPage';
import CatalogsPage from './pages/CatalogsPage';
import OrdersPage from './pages/OrdersPage';
import CustomersPage from './pages/CustomersPage';
import QuotationManagement from './pages/QuotationManagement';
import SettingsPage from './pages/SettingsPage';
import BannerSliderPage from './pages/BannerSliderPage';
import AccountingPage from './pages/AccountingPage';
import { useAuth } from './contexts/AuthContext';
import TeamPage from './pages/TeamPage'; // New Page

function App() {
  const { isAuthenticated, isLoading, login, logout } = useAuth();

  if (isLoading) {
    return (
      <div className="min-h-screen flex items-center justify-center bg-gray-50">
        <div className="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600"></div>
      </div>
    );
  }

  if (!isAuthenticated) {
    return <LoginPage onLogin={(token, user) => login(token, user as any)} />;
  }

  return (
    <DashboardLayout onLogout={logout}>
      <Routes>
        <Route path="/" element={<DashboardHome />} />
        <Route path="/products" element={<ProductsPage />} />
        <Route path="/products/create" element={<CreateProductPage />} />
        <Route path="/products/edit/:id" element={<CreateProductPage />} />
        <Route path="/categories" element={<CategoriesPage />} />
        <Route path="/catalogs" element={<CatalogsPage />} />
        <Route path="/orders" element={<OrdersPage />} />
        <Route path="/customers" element={<CustomersPage />} />
        <Route path="/quotations" element={<QuotationManagement />} />
        <Route path="/accounting" element={<AccountingPage />} />
        <Route path="/marketing/banners" element={<BannerSliderPage />} />
        <Route path="/settings" element={<SettingsPage />} />
        <Route path="/team" element={<TeamPage />} />
        <Route path="*" element={<Navigate to="/" replace />} />
      </Routes>
    </DashboardLayout>
  );
}

export default App;
